<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

require "config/db.php";

$user_id = (int)$_SESSION['user_id'];

/* =========================
   FETCH USER DETAILS
========================= */
$stmt = $conn->prepare("SELECT name, Contact, email, occupation, country FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();
?>

<?php require "includes/head.php"; ?>
<?php require "includes/navbar.php"; ?>

<div class="container my-4">
    <h4 class="mb-4"><i class="bi bi-person-circle me-2"></i>User Profile</h4>

    <div class="row justify-content-center">
        <div class="col-md-6">

            <div class="card">
                <div class="card-body">
                    <form id="userForm">

                        <!-- Name -->
                        <div class="mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" 
                                   value="<?= htmlspecialchars($user['name'] ?? '') ?>" required>
                        </div>

                        <!-- Contact -->
                        <div class="mb-3">
                            <label class="form-label">Contact</label>
                            <input type="text" name="Contact" class="form-control"
                                   value="<?= htmlspecialchars($user['Contact'] ?? '') ?>">
                        </div>

                        <!-- Email -->
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control"
                                   value="<?= htmlspecialchars($user['email'] ?? '') ?>" required>
                        </div>

                        <!-- Occupation -->
                        <div class="mb-3">
                            <label class="form-label">Occupation</label>
                            <input type="text" name="occupation" class="form-control"
                                   value="<?= htmlspecialchars($user['occupation'] ?? '') ?>">
                        </div>

                        <!-- Country -->
                        <div class="mb-3">
                            <label class="form-label">Country</label>
                            <input type="text" name="country" class="form-control"
                                   value="<?= htmlspecialchars($user['country'] ?? '') ?>">
                        </div>

                        <!-- Password Reset -->
                        <div class="mb-3">
                            <label class="form-label">New Password</label>
                            <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Confirm New Password</label>
                            <input type="password" name="password_confirm" class="form-control" placeholder="Confirm new password">
                        </div>

                        <div id="userMsg"></div>

                        <button type="submit" class="btn btn-success w-100">
                            <i class="bi bi-save me-1"></i>Update Profile
                        </button>

                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- jQuery & SweetAlert -->
 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    $('#userForm').submit(function(e) {
        e.preventDefault();
        let formData = $(this).serialize();

        $.ajax({
            url: 'users/update_user.php',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Updated!',
                        text: 'Your profile has been updated.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: res.message || 'Update failed.'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Unexpected Error',
                    text: 'Please try again later.'
                });
            }
        });
    });
});
</script>

<?php
if(isset($conn) && $conn instanceof mysqli) {
    $conn->close();
}
?>
