<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']);
    exit;
}

require '../config/db.php';

$user_id     = $_SESSION['user_id'];
$occupation  = trim($_POST['occupation'] ?? '');
$salary      = floatval($_POST['salary'] ?? 0);
$salary_date = $_POST['salary_date'] ?? '';

if (!$occupation || $salary <= 0 || !$salary_date) {
    echo json_encode(['status'=>'error','message'=>'Invalid input']);
    exit;
}

/* UPSERT */
$stmt = $conn->prepare("
    INSERT INTO user_settings (user_id, occupation, salary, salary_date)
    VALUES (?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
        occupation = VALUES(occupation),
        salary = VALUES(salary),
        salary_date = VALUES(salary_date)
");
$stmt->bind_param("isds", $user_id, $occupation, $salary, $salary_date);
$stmt->execute();

echo json_encode(['status'=>'success']);
