<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>GatPOS | Smart Expense Management</title>

<link rel="icon" href="images/G-logo.png">

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<!-- Google Font -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

<!-- SweetAlert -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{
    min-height:100vh;
    background:url('images/time-is-money.jpg') center/cover no-repeat;
    display:flex;
    justify-content:center;
    align-items:center;
    font-family:'Poppins', sans-serif;
}

/* Card */
.login-card{
    background:#ffffff;
    max-width:420px;
    width:100%;
    padding:30px;
    border-radius:16px;
    box-shadow:0 12px 30px rgba(0,0,0,.25);
    margin:20px;
}

.logo{
    width:90px;
    margin-bottom:15px;
}

label{
    font-size:14px;
    font-weight:500;
}

.form-control,
.btn{
    border-radius:8px;
}


</style>
</head>

<body>

<div class="login-card text-center">
    <img src="images/logo-white.jpg" class="logo" alt="GatPOS">

<!-- ================= LOGIN ================= -->
<form id="loginForm">
    <h5 class="mb-3">Smart Expense Management</h5>

    <div class="mb-3 text-start">
        <label>Phone Number</label>
        <input type="text" name="phone" class="form-control" required>
    </div>

    <div class="mb-3 text-start">
        <label>Password</label>
        <input type="password" name="password" class="form-control" required>
    </div>

    <button type="button" id="loginBtn" class="btn btn-primary w-100 mb-2">
        Login
    </button>

    <button type="button" id="forgotPasswordBtn" class="btn btn-link text-decoration-none">
        Forgot password?
    </button>

    <button type="button" class="btn btn-secondary w-100" id="showRegister">
        Create account
    </button>
</form>

<!-- ================= REGISTER ================= -->
<form id="registerForm" style="display:none;">
    <h5 class="mb-3">Create Account</h5>

    <input type="text" name="name" class="form-control mb-2" placeholder="Full Name" required>
    <input type="email" name="email" class="form-control mb-2" placeholder="Email" required>
    <input type="text" name="phone" class="form-control mb-2" placeholder="Phone Number" required>
    <input type="password" name="password" class="form-control mb-3" placeholder="6-digit password" required>

    <button type="button" id="registerBtn" class="btn btn-success w-100 mb-2">
        Register
    </button>

    <button type="button" class="btn btn-primary w-100" id="showLogin">
        Back to Login
    </button>
</form>

</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
$(document).ready(function(){

/* Toggle forms */
$('#showRegister').click(()=>{
    $('#loginForm').hide();
    $('#registerForm').show();
});

$('#showLogin').click(()=>{
    $('#registerForm').hide();
    $('#loginForm').show();
});

/* ================= LOGIN ================= */
$('#loginBtn').click(async function(){

    const formData = new FormData(document.getElementById('loginForm'));

    try{
        const res = await fetch('auth/login.php',{
            method:'POST',
            body:formData
        });

        const text = await res.text();
        let json;

        try{ json = JSON.parse(text); }
        catch{ Swal.fire('Error','Invalid server response','error'); return; }

        if(json.status === 'success'){
            Swal.fire({
                icon:'success',
                title:'Welcome Back',
                text:json.message,
                timer:1200,
                showConfirmButton:false
            }).then(()=> window.location.href = json.redirect);
        }else{
            Swal.fire('Login Failed', json.message, 'error');
        }

    }catch(err){
        Swal.fire('Error','Network error. Try again','error');
    }
});

/* ================= REGISTER + OTP ================= */
$('#registerBtn').click(async function(){

    const form = document.getElementById('registerForm');
    const phone = form.phone.value.trim();

    try{
        /* Send OTP */
        let send = await fetch('OTP/registration_otp.php',{
            method:'POST',
            headers:{'Content-Type':'application/x-www-form-urlencoded'},
            body:'number='+encodeURIComponent(phone)
        });
        send = await send.json();
        if(send.status!=='success') throw new Error(send.message);

        /* Enter OTP */
        const {value:otp} = await Swal.fire({
            title:'OTP Verification',
            input:'text',
            inputPlaceholder:'Enter 6-digit OTP',
            showCancelButton:true,
            inputValidator:v=>!/^\d{6}$/.test(v)&&'Invalid OTP'
        });
        if(!otp) return;

        /* Verify OTP */
        let verify = await fetch('OTP/verify_registration_otp.php',{
            method:'POST',
            headers:{'Content-Type':'application/x-www-form-urlencoded'},
            body:`number=${phone}&code=${otp}`
        });
        verify = await verify.json();
        if(verify.status!=='success') throw new Error(verify.message);

        /* Register */
        const res = await fetch('auth/register.php',{
            method:'POST',
            body:new FormData(form)
        });
        const json = await res.json();

        if(json.status==='success'){
            Swal.fire('Success','Account created successfully','success');
            form.reset();
            $('#registerForm').hide();
            $('#loginForm').show();
        }else{
            throw new Error(json.message);
        }

    }catch(err){
        Swal.fire('Error', err.message, 'error');
    }
});

/* ================= FORGOT PASSWORD ================= */
$('#forgotPasswordBtn').click(async function(){

    try{
        const {value:number} = await Swal.fire({
            title:'Forgot Password',
            input:'text',
            inputPlaceholder:'Enter phone number',
            showCancelButton:true
        });
        if(!number) return;

        let send = await fetch('OTP/forgot_password_send_otp.php',{
            method:'POST',
            headers:{'Content-Type':'application/x-www-form-urlencoded'},
            body:'number='+encodeURIComponent(number)
        });
        send = await send.json();
        if(send.status!=='success') throw new Error(send.message);

        const {value:otp} = await Swal.fire({
            title:'Enter OTP',
            input:'text',
            showCancelButton:true
        });
        if(!otp) return;

        let verify = await fetch('OTP/forgot_password_verify_otp.php',{
            method:'POST',
            headers:{'Content-Type':'application/x-www-form-urlencoded'},
            body:`number=${number}&code=${otp}`
        });
        verify = await verify.json();
        if(verify.status!=='success') throw new Error(verify.message);

        const {value:newPass} = await Swal.fire({
            title:'New Password',
            input:'password',
            showCancelButton:true
        });
        if(!newPass) return;

        let reset = await fetch('OTP/forgot_password_reset.php',{
            method:'POST',
            headers:{'Content-Type':'application/x-www-form-urlencoded'},
            body:`number=${number}&new_password=${newPass}`
        });
        reset = await reset.json();

        if(reset.status==='success'){
            Swal.fire('Success','Password updated','success');
        }else{
            throw new Error(reset.message);
        }

    }catch(err){
        Swal.fire('Error', err.message, 'error');
    }
});

});
</script>

</body>
</html>
