<!-- Preloader -->
<div id="preloader">
  <div class="loader">
    <div class="bars">
      <div class="bar"></div>
      <div class="bar"></div>
      <div class="bar"></div>
      <div class="bar"></div>
      <div class="bar"></div>
    </div>
    <div class="loader-text">Gatpros SEM</div>
  </div>
</div>

<style>
/* Full-page preloader */
#preloader {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: #ffffff;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 9999;
}

/* Loader container */
.loader {
  text-align: center;
}

/* Bars container */
.loader .bars {
  display: flex;
  gap: 6px;
  justify-content: center;
  align-items: flex-end;
  margin-bottom: 15px;
}

/* Individual bars */
.loader .bar {
  width: 12px;
  height: 30px;
  background: linear-gradient(180deg, #2563EB 0%, #16A34A 100%);
  border-radius: 4px;
  animation: bounce 1s infinite ease-in-out;
}

/* Staggered delays for wave effect */
.loader .bar:nth-child(1) { animation-delay: 0s; }
.loader .bar:nth-child(2) { animation-delay: 0.15s; }
.loader .bar:nth-child(3) { animation-delay: 0.3s; }
.loader .bar:nth-child(4) { animation-delay: 0.45s; }
.loader .bar:nth-child(5) { animation-delay: 0.6s; }

/* Bounce animation */
@keyframes bounce {
  0%, 100% { transform: scaleY(0.3); }
  50% { transform: scaleY(1); }
}

/* Loader text */
.loader-text {
  font-size: 1.4rem;
  font-weight: 700;
  color: #2563EB;
  letter-spacing: 1.2px;
}

/* Mobile responsiveness */
@media (max-width: 576px) {
  .loader .bar {
    width: 8px;
    height: 24px;
  }
  .loader-text {
    font-size: 1.2rem;
  }
}
</style>

<script>
// Hide preloader when page is fully loaded
window.addEventListener('load', () => {
  const preloader = document.getElementById('preloader');
  preloader.style.opacity = '0';
  preloader.style.transition = 'opacity 0.5s ease';
  setTimeout(() => preloader.style.display = 'none', 500);
});
</script>
