<!-- =========================
TOP NAVBAR / BRAND + USER
========================= -->
<nav class="navbar bg-white shadow-sm px-3 d-flex align-items-center justify-content-between sticky-top">

    <!-- Brand with icon beside text -->
    <a class="navbar-brand fw-semibold text-primary m-0 d-flex align-items-center" href="index.php">
        <i class="bi bi-bar-chart-fill fs-5 me-1"></i>
        GatPros SEM
    </a>

    <!-- Spacer for alignment -->
    <div></div>

    <!-- User dropdown -->
    <div class="dropdown">
        <button class="btn btn-outline-secondary btn-sm dropdown-toggle" data-bs-toggle="dropdown">
            <i class="bi bi-person-circle me-1"></i>
            <?= htmlspecialchars($user['name']) ?>
        </button>
        <ul class="dropdown-menu dropdown-menu-end">
            <li><h6 class="dropdown-header">Profile</h6></li>
            <li><a class="dropdown-item" href="profile">Edit Details</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="logout">Logout</a></li>
        </ul>
    </div>
</nav>

<!-- =========================
DESKTOP NAVBAR
========================= -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm px-3 d-none d-md-flex">
    <div class="container-fluid">

        <ul class="navbar-nav me-auto">
            <li class="nav-item">
                <a class="nav-link py-1 text-dark" href="dashboard">
                    <i class="bi bi-speedometer2 me-1"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link py-1 text-dark" href="expenses">
                    <i class="bi bi-receipt me-1"></i> Expenses
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link py-1 text-dark" href="planned">
                    <i class="bi bi-clipboard-check me-1"></i> Planned
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link py-1 text-dark" href="savings">
                    <i class="bi bi-piggy-bank me-1"></i> Savings
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link py-1 text-dark" href="loans">
                    <i class="bi bi-cash-coin me-1"></i> Loans
                </a>
            </li>
        </ul>

    </div>
</nav>

<!-- =========================
MOBILE BOTTOM NAV (5 ITEMS)
========================= -->
<nav class="navbar navbar-light bg-white shadow-lg fixed-bottom d-md-none">
    <ul class="nav nav-justified w-100" style="font-size:0.65rem;">
        <li class="nav-item text-center">
            <a class="nav-link p-1 text-dark" href="dashboard">
                <i class="bi bi-speedometer2 fs-5"></i> Dash
            </a>
        </li>
        <li class="nav-item text-center">
            <a class="nav-link p-1 text-dark" href="expenses">
                <i class="bi bi-receipt fs-5"></i> Expense
            </a>
        </li>
        <li class="nav-item text-center">
            <a class="nav-link p-1 text-dark" href="planned">
                <i class="bi bi-clipboard-check fs-5"></i> Plan
            </a>
        </li>
        <li class="nav-item text-center">
            <a class="nav-link p-1 text-dark" href="savings">
                <i class="bi bi-piggy-bank fs-5"></i> Save
            </a>
        </li>
        <li class="nav-item text-center">
            <a class="nav-link p-1 text-dark" href="loans">
                <i class="bi bi-cash-coin fs-5"></i> Loan
            </a>
        </li>
    </ul>
</nav>

<!-- =========================
UI FIXES
========================= -->
<style>
body {
    padding-bottom: 65px; /* prevent bottom nav overlap */
}

.navbar i {
    color: inherit;
}

.nav-link.active {
    font-weight: 600;
}
</style>
