<script>
function viewExpenses(category) {

  // Set modal title
  document.getElementById('viewExpensesTitle').innerText =
    category + ' Expenses';

  // Show loading
  document.getElementById('viewExpensesBody').innerHTML =
    '<div class="text-center py-4"><div class="spinner-border"></div></div>';

  // Open the CORRECT modal
  const modal = new bootstrap.Modal(
    document.getElementById('viewExpensesModal')
  );
  modal.show();

  // Load expenses via AJAX
  fetch('expenses/view_by_category.php?category=' + encodeURIComponent(category))
    .then(res => res.text())
    .then(html => {
      document.getElementById('viewExpensesBody').innerHTML = html;
    })
    .catch(() => {
      document.getElementById('viewExpensesBody').innerHTML =
        '<div class="alert alert-danger">Failed to load expenses</div>';
    });
}
</script>
<script>
function addExpenseRow(){
  let row = document.querySelector('.expense-row').cloneNode(true);
  row.querySelectorAll('input').forEach(i=>{
    if(i.type !== 'date') i.value='';
  });
  row.querySelectorAll('select').forEach(s=>s.value='');
  document.getElementById('expenseRows').appendChild(row);
}

function removeExpenseRow(btn){
  let rows=document.querySelectorAll('.expense-row');
  if(rows.length>1) btn.closest('.expense-row').remove();
}

document.getElementById('expenseForm').addEventListener('submit', async e=>{
  e.preventDefault();

  let btn=document.getElementById('saveExpenseBtn');
  btn.disabled=true;
  btn.querySelector('.etxt').textContent='Saving...';
  btn.querySelector('.spinner-border').classList.remove('d-none');

  try{
    let r=await fetch('expenses/add_expense.php',{
      method:'POST',
      body:new FormData(e.target)
    });

    let j=JSON.parse(await r.text());

    if(j.status==='success'){
      Swal.fire({
        icon:'success',
        title:'Saved!',
        text:'Expenses added successfully',
        timer:1500,
        showConfirmButton:false
      }).then(()=>location.reload());
    }else{
      Swal.fire('Error',j.message,'error');
    }
  }catch{
    Swal.fire('Error','Server error','error');
  }finally{
    btn.disabled=false;
    btn.querySelector('.etxt').textContent='Save Expenses';
    btn.querySelector('.spinner-border').classList.add('d-none');
  }
});
</script>


<script>
// Calculate total planned amount
function updateTotalPlanned(){
    let total = 0;

    // Query all amount inputs, even dynamically added
    document.querySelectorAll('.planned-amount').forEach(input => {
        total += parseFloat(input.value) || 0;
    });

    // Show total
    document.getElementById('totalPlannedAmount').value = '₵ ' + total.toFixed(2);

    // Check budget
    let budget = parseFloat(document.getElementById('monthlyBudget').value) || 0;
    if(budget > 0 && total > budget){
        document.getElementById('totalPlannedAmount').style.backgroundColor = '#f87171'; // red
    } else {
        document.getElementById('totalPlannedAmount').style.backgroundColor = '#d1fae5'; // green
    }
}

// Listen for input changes globally (including dynamically added rows)
document.addEventListener('input', function(e){
    if(e.target && e.target.classList.contains('planned-amount')){
        updateTotalPlanned();
    }
});

// Budget input listener
document.getElementById('monthlyBudget').addEventListener('input', updateTotalPlanned);

// Initial total calculation
updateTotalPlanned();

// Add a new plan row
function addPlanRow(){
    let original = document.querySelector('.plan-row');
    let row = original.cloneNode(true);

    // Clear inputs
    row.querySelectorAll('input').forEach(i => { if(i.type !== 'date') i.value=''; });
    row.querySelectorAll('select').forEach(s => { if(s.name==='plan_type[]') s.value='month'; else s.value=''; });

    document.getElementById('planRows').appendChild(row);

    // Update total immediately
    updateTotalPlanned();
}

// Remove plan row
function removePlanRow(btn){
    let rows = document.querySelectorAll('.plan-row');
    if(rows.length > 1){
        btn.closest('.plan-row').remove();
        updateTotalPlanned();
    }
}

// --- INITIAL LISTENERS ---
document.querySelectorAll('.planned-amount').forEach(input=>{
    input.addEventListener('input', updateTotalPlanned);
});

// Budget input listener
document.getElementById('monthlyBudget').addEventListener('input', updateTotalPlanned);

// Form submission
document.getElementById('planForm').addEventListener('submit', async e=>{
    e.preventDefault();
    const btn = document.getElementById('savePlanBtn');
    btn.disabled = true;
    btn.querySelector('.ptxt').textContent = 'Saving...';
    btn.querySelector('.spinner-border').classList.remove('d-none');

    try{
        const res = await fetch('expenses/plan_expense.php',{
            method:'POST',
            body: new FormData(e.target)
        });
        const j = await res.json();

        if(j.status === 'success'){
            Swal.fire({icon:'success',title:'Saved!',timer:1500,showConfirmButton:false})
                 .then(()=> location.reload());
        } else {
            Swal.fire('Error', j.message, 'error');
        }
    } catch(err){
        Swal.fire('Error','Server error','error');
    } finally {
        btn.disabled = false;
        btn.querySelector('.ptxt').textContent = 'Save Planned Expenses';
        btn.querySelector('.spinner-border').classList.add('d-none');
    }
});

// --- INITIAL TOTAL CALCULATION ---
updateTotalPlanned();
</script>

<script>
document.getElementById('incomeForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const form = this;
    const data = new FormData(form);

    Swal.fire({
        title: 'Saving income...',
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    fetch('expenses/add_income.php', {
        method: 'POST',
        body: data
    })
    .then(res => res.json())
    .then(res => {
        if (res.status === 'success') {
            Swal.fire({
                icon: 'success',
                title: 'Success',
                text: res.message || 'Income added successfully',
                timer: 1500,
                showConfirmButton: false
            });

            form.reset();

            const modal = bootstrap.Modal.getInstance(
                document.getElementById('incomeModal')
            );
            modal.hide();

            // OPTIONAL: refresh dashboard data
            // loadIncomeSummary();

        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: res.message || 'Failed to add income'
            });
        }
    })
    .catch(() => {
        Swal.fire({
            icon: 'error',
            title: 'Network Error',
            text: 'Please check your internet connection'
        });
    });
});
</script>

<script>
document.getElementById('savingsForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const form = this;
    const formData = new FormData(form);

    fetch('expenses/add_savings.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {

        if (data.status === 'success') {

            Swal.fire({
                icon: 'success',
                title: 'Saved!',
                text: 'Savings added successfully',
                timer: 1500,
                showConfirmButton: false
            });

            form.reset();

            const modal = bootstrap.Modal.getInstance(
                document.getElementById('savingsModal')
            );
            modal.hide();

            // OPTIONAL: reload KPIs / page
            // location.reload();

        } else {
            Swal.fire('Error', data.message, 'error');
        }
    })
    .catch(() => {
        Swal.fire('Error', 'Something went wrong', 'error');
    });
});
</script>
<!-- AJAX + SweetAlert -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){

    $('#loanForm').on('submit', function(e){
        e.preventDefault(); // stop default submit

        var formData = $(this).serialize();

        $.ajax({
            url: 'expenses/add_loan.php',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(res){
                if(res.status === 'success'){
                    Swal.fire({
                        icon: 'success',
                        title: 'Loan Added!',
                        text: 'Your loan has been recorded successfully.',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    $('#loanForm')[0].reset();
                    $('#loanModal').modal('hide');

                    // Optional: refresh your tables or KPIs
                    if(typeof refreshLoanKPIs === 'function') refreshLoanKPIs();

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: res.message || 'Something went wrong.'
                    });
                }
            },
            error: function(xhr, status, error){
                console.error(error);
                Swal.fire({
                    icon: 'error',
                    title: 'Unexpected Error',
                    text: 'Please try again.'
                });
            }
        });
    });

});
</script>
<script>
$(document).ready(function() {
    // Update max repay amount when a loan is selected
    $('#loanSelect').change(function() {
        let balance = parseFloat($(this).find(':selected').data('balance') || 0);
        $('#repayAmount').attr('max', balance).val(balance);
    });

    // Submit repayment via AJAX
    $('#repayLoanForm').submit(function(e) {
        e.preventDefault();
        let loanId = $('#loanSelect').val();
        let amount = parseFloat($('#repayAmount').val());
        let maxAmount = parseFloat($('#repayAmount').attr('max'));

        if (!loanId || amount <= 0 || amount > maxAmount) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid amount',
                text: 'Please enter a valid repayment amount.'
            });
            return;
        }

        $.post('expenses/repay_loan.php', {
            loan_id: loanId,
            amount: amount
        }, function(res) {
            if (res.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'Loan Repaid!',
                    text: 'The repayment has been successfully recorded.',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => location.reload());
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: res.message || 'Failed to repay the loan.'
                });
            }
        }, 'json').fail(function() {
            Swal.fire({
                icon: 'error',
                title: 'Unexpected Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });
});
</script>






