<!-- VIEW EXPENSES MODAL -->
<div class="modal fade" id="viewExpensesModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title" id="viewExpensesTitle">Expenses</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="viewExpensesBody">
        <div class="text-center py-4">
          <div class="spinner-border"></div>
        </div>
      </div>

    </div>
  </div>
</div>


<!-- USER SETTINGS MODAL -->
<div class="modal fade" id="userSettingsModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <!-- HEADER -->
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="bi bi-gear-fill text-primary"></i> User Settings
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- BODY -->
      <div class="modal-body">
        <form id="userSettingsForm">

          <!-- OCCUPATION -->
          <div class="mb-4">
            <label class="form-label fw-semibold">
              Occupation
            </label>
            <small class="text-muted d-block mb-2">
              Select what best describes your current occupation
            </small>

            <select name="occupation"
                    class="form-select form-select-lg"
                    required>
              <option value="">Select occupation</option>
              <option value="Employed" <?= $settings['occupation']=='Employed'?'selected':'' ?>>Employed</option>
              <option value="Self Employed" <?= $settings['occupation']=='Self Employed'?'selected':'' ?>>Self Employed</option>
              <option value="Freelancer" <?= $settings['occupation']=='Freelancer'?'selected':'' ?>>Freelancer</option>
              <option value="Student" <?= $settings['occupation']=='Student'?'selected':'' ?>>Student</option>
              <option value="Unemployed" <?= $settings['occupation']=='Unemployed'?'selected':'' ?>>Unemployed</option>
            </select>
          </div>

          <!-- SALARY -->
          <div class="mb-4">
            <label class="form-label fw-semibold">
              Monthly Salary
            </label>
            <small class="text-muted d-block mb-2">
              Enter your expected monthly income
            </small>

            <input type="number"
                   name="salary"
                   class="form-control form-control-lg"
                   placeholder="e.g. 2500"
                   value="<?= htmlspecialchars($settings['salary']) ?>"
                   min="0">
          </div>

          <!-- SALARY DAY -->
          <div class="mb-4">
            <label class="form-label fw-semibold">
              Estimated Salary Day
            </label>
            <small class="text-muted d-block mb-2">
              Day of the month your salary is usually paid
            </small>

            <select name="salary_date"
                    class="form-select form-select-lg"
                    required>
              <option value="">Select day</option>

              <?php
              $selectedDay = '';
              if (!empty($settings['salary_date'])) {
                $selectedDay = date('j', strtotime($settings['salary_date']));
              }

              for ($d = 1; $d <= 31; $d++):
                $selected = ($selectedDay == $d) ? 'selected' : '';
              ?>
                <option value="<?= $d ?>" <?= $selected ?>>
                  <?= ordinal($d) ?> of every month
                </option>
              <?php endfor; ?>
            </select>
          </div>

          <!-- SAVE -->
          <button type="submit"
                  class="btn btn-primary w-100 py-3"
                  id="saveSettingsBtn">
            <span class="stxt">Save Settings</span>
            <span class="spinner-border spinner-border-sm d-none"></span>
          </button>

        </form>
      </div>

    </div>
  </div>
</div>


<!-- ADD EXPENSE MODAL -->
<div class="modal fade" id="expenseModal">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5>Add Expenses</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <form id="expenseForm">

          <!-- DATE SELECT -->
  <div class="row mb-4">
  <div class="col-md-4">
    <label class="form-label fw-semibold">Expense Date</label>

    <!-- Human readable display -->
    <input
      type="text"
      id="expenseDateText"
      class="form-control form-control-lg"
      readonly
      style="cursor:pointer;"
    >

    <!-- REAL date picker (hidden but clickable) -->
    <input
      type="date"
      id="expenseDate"
      name="expense_date"
      class="position-absolute opacity-0"
      style="pointer-events:none;"
      value="<?= date('Y-m-d') ?>"
    >
  </div>
</div>






          <!-- EXPENSE ROWS -->
<div id="expenseRows">

            <div class="row g-3 expense-row mb-3 align-items-end">

              <div class="col-md-2">
                <label class="form-label">Amount</label>
                <input type="number" name="amount[]" class="form-control form-control-lg" required>
              </div>

             <div class="col-md-3">
  <label class="form-label fw-semibold">Category</label>
  <select name="category_id[]" class="form-select form-select-lg" required>
    <option value="">Select category</option>

    <?php foreach ($categories as $cat): ?>
      <option value="<?= $cat['id'] ?>">
        <?= htmlspecialchars($cat['name']) ?>
      </option>
    <?php endforeach; ?>

  </select>
</div>


              <div class="col-md-5">
                <label class="form-label">Description</label>
                <input type="text" name="description[]" class="form-control form-control-lg">
              </div>

              <div class="col-md-2 d-flex gap-2">
                <button type="button" class="btn btn-success btn-lg" onclick="addExpenseRow()">+</button>
                <button type="button" class="btn btn-danger btn-lg" onclick="removeExpenseRow(this)">×</button>
              </div>

            </div>
          </div>

          <button class="btn btn-primary w-100 py-3" id="saveExpenseBtn">
            <span class="etxt">Save Expenses</span>
            <span class="spinner-border spinner-border-sm d-none"></span>
          </button>

        </form>
      </div>

    </div>
  </div>
</div>



<!-- PLAN MODAL -->
<div class="modal fade" id="planModal">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="fw-semibold">Plan Expenses</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">

        <!-- BUDGET & TOTAL -->
     <!-- Add this to your modal form -->
<div class="mb-2">
  <label class="form-label">Monthly Budget</label>
  <input type="number" id="monthlyBudget" class="form-control" placeholder="₵ 0.00" value="">
</div>

<div class="mb-2">
  <label class="form-label">Total Planned</label>
  <input type="text" id="totalPlannedAmount" class="form-control" readonly value="₵ 0.00" style="background:#d1fae5">
</div>


        <form id="planForm">

          <div id="planRows">

            <!-- PLAN ROW -->
            <div class="row g-3 plan-row mb-3 align-items-end">

              <!-- PLAN TYPE -->
              <div class="col-md-2">
                <label class="form-label fw-semibold">Plan Type</label>
                <select name="plan_type[]" class="form-select form-select-lg" required>
                  <option value="today">Daily</option>
                  <option value="week">Weekly</option>
                  <option value="month" selected>Monthly</option>
                </select>
              </div>

              <!-- CATEGORY -->
              <div class="col-md-3">
                <label class="form-label fw-semibold">Category</label>
                <select name="category_id[]" class="form-select form-select-lg" required>
                  <option value="">Select category</option>
                  <?php foreach ($categories as $cat): ?>
                  <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>

              <!-- AMOUNT -->
              <div class="col-md-2">
                <label class="form-label fw-semibold">Amount</label>
                <input type="number" name="planned_amount[]" class="form-control form-control-lg planned-amount" placeholder="₵ 0.00" required>
              </div>

              <!-- PLANNED DATE -->
              <div class="col-md-3">
                <label class="form-label fw-semibold">Planned Date</label>
                <input type="date" name="planned_date[]" class="form-control form-control-lg" value="<?= date('Y-m-d') ?>" required>
              </div>

              <!-- ACTION BUTTONS -->
              <div class="col-md-2 d-flex gap-2">
                <button type="button" class="btn btn-success btn-lg" onclick="addPlanRow()">+</button>
                <button type="button" class="btn btn-danger btn-lg" onclick="removePlanRow(this)">×</button>
              </div>

            </div>
            <!-- END PLAN ROW -->

          </div>

          <!-- SAVE BUTTON -->
          <button class="btn btn-warning w-100 py-3 mt-2" id="savePlanBtn">
            <span class="ptxt fw-semibold">Save Planned Expenses</span>
            <span class="spinner-border spinner-border-sm d-none"></span>
          </button>

        </form>
      </div>

    </div>
  </div>
</div>


<!-- ADD INCOME MODAL -->
<div class="modal fade" id="incomeModal" tabindex="-1" aria-labelledby="incomeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title" id="incomeModalLabel">
          <i class="bi bi-cash-coin me-1"></i> Add Income
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <form id="incomeForm">

        <div class="modal-body">

          <!-- Income Type -->
          <div class="mb-3">
            <label class="form-label fw-semibold">Income Source</label>
            <select name="income_type" class="form-select" required>
              <option value="">Select income type</option>
              <option value="salary">Salary</option>
              <option value="side_hustle">Side Hustle</option>
              <option value="others">Others</option>
            </select>
          </div>

          <!-- Amount -->
          <div class="mb-3">
            <label class="form-label fw-semibold">Amount</label>
            <div class="input-group">
              <span class="input-group-text">₵</span>
              <input type="number" name="amount" class="form-control" step="0.01" min="0" required>
            </div>
          </div>

          <!-- Note -->
          <div class="mb-3">
            <label class="form-label fw-semibold">
              Note <small class="text-muted">(optional)</small>
            </label>
            <textarea name="note" class="form-control" rows="2"
                      placeholder="e.g. January salary, freelance job"></textarea>
          </div>

        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success">
            <i class="bi bi-check-circle me-1"></i> Save Income
          </button>
        </div>

      </form>

    </div>
  </div>
</div>

<!-- ADD SAVINGS MODAL -->
<div class="modal fade" id="savingsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">
          <i class="bi bi-piggy-bank me-2"></i>Add Savings
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <form id="savingsForm">

        <div class="modal-body">

          <!-- Savings Type -->
          <div class="mb-3">
            <label class="form-label">Savings Type</label>
            <select name="savings_type" class="form-select form-select-lg" required>
              <option value="">Select type</option>
              <option value="emergency">Emergency</option>
              <option value="goal">Goal</option>
              <option value="investment">Investment</option>
              <option value="other">Other</option>
            </select>
          </div>

          <!-- Amount -->
          <div class="mb-3">
            <label class="form-label">Amount</label>
            <input type="number"
                   name="amount"
                   class="form-control form-control-lg"
                   min="0.01"
                   step="0.01"
                   placeholder="₵ 0.00"
                   required>
          </div>

          <!-- Date -->
          <div class="mb-3">
            <label class="form-label">Savings Date</label>
            <input type="date"
                   name="savings_date"
                   class="form-control form-control-lg"
                   value="<?= date('Y-m-d') ?>"
                   required>
          </div>

          <!-- Note -->
          <div class="mb-2">
            <label class="form-label">Note (optional)</label>
            <textarea name="note"
                      class="form-control"
                      rows="2"
                      placeholder="e.g. January emergency savings"></textarea>
          </div>

        </div>

        <div class="modal-footer">
          <button type="button"
                  class="btn btn-light"
                  data-bs-dismiss="modal">
            Cancel
          </button>

          <button type="submit"
                  class="btn btn-success">
            <i class="bi bi-check-circle me-1"></i>Save
          </button>
        </div>

      </form>

    </div>
  </div>
</div>


<!-- ADD LOAN MODAL -->
<div class="modal fade" id="loanModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title"><i class="bi bi-currency-exchange me-2"></i>Add Loan</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <form id="loanForm" autocomplete="off">

        <div class="modal-body">

          <!-- Loan Category -->
          <div class="mb-3">
            <label class="form-label">Category</label>
            <select name="category_id" class="form-select form-select-lg" required>
              <option value="">Select Category</option>
              <?php
                // Fetch categories from DB
                $catStmt = $conn->prepare("SELECT id, name FROM categories ORDER BY name");
                $catStmt->execute();
                $catRes = $catStmt->get_result();
                while($cat = $catRes->fetch_assoc()){
                  echo '<option value="'.$cat['id'].'">'.htmlspecialchars($cat['name']).'</option>';
                }
                $catStmt->close();
              ?>
            </select>
          </div>

          <!-- Loan Source -->
          <div class="mb-3">
            <label class="form-label">Loan Source</label>
            <select name="loan_source" class="form-select form-select-lg" required>
              <option value="">Select Source</option>
              <option value="savings">Savings</option>
              <option value="friends">Friends</option>
              <option value="bank">Bank</option>
              <option value="other">Other</option>
            </select>
          </div>

          <!-- Amount -->
          <div class="mb-3">
            <label class="form-label">Amount</label>
            <input type="number" name="amount" class="form-control form-control-lg"
                   min="0.01" step="0.01" placeholder="₵ 0.00" required>
          </div>

          <!-- Date -->
          <div class="mb-3">
            <label class="form-label">Loan Date</label>
            <input type="date" name="loan_date" class="form-control form-control-lg"
                   value="<?= date('Y-m-d') ?>" required>
          </div>

          <!-- Description -->
          <div class="mb-2">
            <label class="form-label">Description (optional)</label>
            <textarea name="description" class="form-control" rows="2"
                      placeholder="e.g. Loan for school fees"></textarea>
          </div>

        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success"><i class="bi bi-check-circle me-1"></i>Save Loan</button>
        </div>

      </form>

    </div>
  </div>
</div>


<!-- Repay Loan Modal -->
<!-- Repay Loan Modal -->
<div class="modal fade" id="repayLoanModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title"><i class="bi bi-cash-coin me-2"></i>Repay Loan</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <form id="repayLoanForm">
        <div class="modal-body">

          <!-- Select Loan -->
          <div class="mb-3">
            <label class="form-label">Select Loan</label>
            <select name="loan_id" id="loanSelect" class="form-select" required>
              <option value="">-- Choose a loan --</option>
              <?php
              // Fetch active loans
              $stmt = $conn->prepare("
                SELECT id, description, amount, repaid_amount
                FROM loans
                WHERE user_id=? AND status='active'
              ");
              $stmt->bind_param("i", $user_id);
              $stmt->execute();
              $res = $stmt->get_result();
              while($loan = $res->fetch_assoc()):
                  $balance = $loan['amount'] - $loan['repaid_amount'];
              ?>
                <option value="<?= $loan['id'] ?>" data-balance="<?= $balance ?>">
                  <?= htmlspecialchars($loan['description'] ?: 'Loan #'.$loan['id']) ?> — Remaining: ₵ <?= number_format($balance,2) ?>
                </option>
              <?php endwhile; $stmt->close(); ?>
            </select>
          </div>

          <!-- Amount -->
          <div class="mb-3">
            <label class="form-label">Amount to Repay</label>
            <input type="number" name="repay_amount" id="repayAmount" class="form-control" min="0.01" step="0.01" placeholder="₵ 0.00" required>
          </div>

        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success">Repay</button>
        </div>
      </form>

    </div>
  </div>
</div>



