<?php
session_start();
require "../config/db.php";

if (!isset($_SESSION['user_id'])) {
    echo "<div class='alert alert-danger'>Unauthorized</div>";
    exit;
}

$user_id  = $_SESSION['user_id'];
$category = $_GET['category'] ?? '';

if ($category === '') {
    echo "<div class='alert alert-warning'>Invalid category</div>";
    exit;
}

/* SINGLE QUERY: FETCH ALL EXPENSES */
$sql = "
SELECT 
    e.expense_date,
    e.amount,
    e.description
FROM expenses e
JOIN categories c ON e.category_id = c.id
WHERE e.user_id = ?
  AND c.name = ?
  AND MONTH(e.expense_date) = MONTH(CURDATE())
  AND YEAR(e.expense_date)  = YEAR(CURDATE())
ORDER BY e.expense_date DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $user_id, $category);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    echo "<div class='text-muted text-center py-3'>
            No expenses recorded for this category
          </div>";
    exit;
}

/* GROUP DATA BY DATE */
$grouped = [];
while ($row = $res->fetch_assoc()) {
    $grouped[$row['expense_date']][] = $row;
}
?>

<table class="table table-sm table-bordered align-middle">
<thead class="table-light">
<tr>
    <th>Date</th>
    <th class="text-end">Total</th>
    <th class="text-center">Details</th>
</tr>
</thead>
<tbody id="expenseAccordion">

<?php foreach ($grouped as $date => $items): 
    $collapseId = 'day_' . strtotime($date);
    $dayTotal = array_sum(array_column($items, 'amount'));
?>
<tr>
    <td><?= date('M d, Y', strtotime($date)) ?></td>
    <td class="text-end fw-semibold">₵<?= number_format($dayTotal, 2) ?></td>
    <td class="text-center">
        <a class="text-decoration-none"
           data-bs-toggle="collapse"
           href="#<?= $collapseId ?>">
            <i class="bi bi-chevron-down"></i>
        </a>
    </td>
</tr>

<tr class="collapse bg-light" id="<?= $collapseId ?>" data-bs-parent="#expenseAccordion">
    <td colspan="3">
        <table class="table table-sm mb-0">
            <thead class="table-secondary">
            <tr>
                <th>Description</th>
                <th class="text-end">Amount</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($items as $item): ?>
            <tr>
                <td><?= htmlspecialchars($item['description'] ?: '-') ?></td>
                <td class="text-end">₵<?= number_format($item['amount'], 2) ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </td>
</tr>

<?php endforeach; ?>

</tbody>
</table>
