<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']);
    exit;
}

require_once '../config/db.php';

$user_id = $_SESSION['user_id'];
$loan_id = (int)($_POST['loan_id'] ?? 0);
$amount  = (float)($_POST['amount'] ?? 0);

$category_id = 13; // ✅ Loan Repayment category

if ($loan_id <= 0 || $amount <= 0) {
    echo json_encode(['status'=>'error','message'=>'Invalid repayment data']);
    exit;
}

$conn->begin_transaction();

try {

    // Get loan info
    $loan = $conn->query("
        SELECT amount, repaid_amount
        FROM loans
        WHERE id = $loan_id
          AND user_id = $user_id
          AND status = 'active'
    ")->fetch_assoc();

    if (!$loan) {
        throw new Exception('Loan not found or already fully paid');
    }

    $remaining = $loan['amount'] - $loan['repaid_amount'];

    if ($amount > $remaining) {
        throw new Exception('Repayment exceeds remaining balance');
    }

    // Update loan
    $newPaid = $loan['repaid_amount'] + $amount;
    $status  = ($newPaid >= $loan['amount']) ? 'paid' : 'active';

    $stmt = $conn->prepare("
        UPDATE loans
        SET repaid_amount = ?, status = ?
        WHERE id = ?
    ");
    $stmt->bind_param("dsi", $newPaid, $status, $loan_id);
    $stmt->execute();

    // 👉 Insert repayment into expenses
    $description = 'Loan repayment';

    $stmt = $conn->prepare("
        INSERT INTO expenses
        (user_id, category_id, amount, description, expense_date, created_at)
        VALUES (?, ?, ?, ?, CURDATE(), NOW())
    ");
    $stmt->bind_param("iids", $user_id, $category_id, $amount, $description);
    $stmt->execute();

    $conn->commit();

    echo json_encode(['status'=>'success']);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode([
        'status'=>'error',
        'message'=>$e->getMessage()
    ]);
}

$conn->close();
