<?php
session_start();
if(!isset($_SESSION['user_id'])){
    echo json_encode(['success'=>false,'message'=>'Unauthorized']);
    exit;
}
require "../config/db.php";

$user_id = (int)$_SESSION['user_id'];
$id = (int)$_POST['id'];
$amount = (float)$_POST['amount'];

$stmt = $conn->prepare("UPDATE planned_expenses SET planned_amount=? WHERE user_id=? AND category_id=? AND plan_type IN ('month','week','day')");
$stmt->bind_param("dii",$amount,$user_id,$id);

if($stmt->execute()){
    echo json_encode(['success'=>true,'message'=>'Planned amount updated']);
} else {
    echo json_encode(['success'=>false,'message'=>'Failed to update']);
}
$stmt->close();
?>
