<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Unauthorized'
    ]);
    exit;
}

require "../config/db.php";

$user_id = (int) $_SESSION['user_id'];

/* INPUT ARRAYS */
$types  = $_POST['plan_type'] ?? [];
$cats   = $_POST['category_id'] ?? [];
$amts   = $_POST['planned_amount'] ?? [];
$notes  = $_POST['note'] ?? [];
$dates  = $_POST['planned_date'] ?? [];

/* PREPARED STATEMENT */
$stmt = $conn->prepare("
    INSERT INTO planned_expenses
    (
        user_id,
        category_id,
        planned_amount,
        plan_type,
        note,
        planned_date,
        month,
        year,
        created_at
    )
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
");

if (!$stmt) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Database error'
    ]);
    exit;
}

/* LOOP THROUGH ROWS */
for ($i = 0; $i < count($amts); $i++) {

    if (
        empty($cats[$i]) ||
        empty($dates[$i]) ||
        !isset($types[$i]) ||
        (float)$amts[$i] <= 0
    ) {
        continue;
    }

    $plannedDate = $dates[$i];
    $month       = (int) date('n', strtotime($plannedDate));
    $year        = (int) date('Y', strtotime($plannedDate));
    $note        = $notes[$i] ?? '';

    $stmt->bind_param(
        "iidsssii",
        $user_id,
        $cats[$i],
        $amts[$i],
        $types[$i],
        $note,
        $plannedDate,
        $month,
        $year
    );

    $stmt->execute();
}

$stmt->close();
$conn->close();

echo json_encode([
    'status' => 'success'
]);
