<?php
session_start();
require "../config/db.php";

$user_id = (int)$_SESSION['user_id'];

$sql = "SELECT IFNULL(SUM(amount),0) AS totalActiveLoans 
        FROM loans 
        WHERE user_id=? AND loan_source='savings' AND status='active'";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$res = $stmt->get_result();
$total = $res->fetch_assoc()['totalActiveLoans'];
$stmt->close();

echo json_encode(['totalActiveLoans' => (float)$total]);
