<?php
session_start();
header('Content-Type: application/json');

if (empty($_SESSION['user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Unauthorized'
    ]);
    exit;
}

require "../config/db.php";

$user_id     = (int) $_SESSION['user_id'];
$id          = isset($_POST['id']) ? (int) $_POST['id'] : 0;
$description = trim($_POST['description'] ?? '');
$amount      = isset($_POST['amount']) ? (float) $_POST['amount'] : 0;

if ($id <= 0 || $amount <= 0 || $description === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid input data'
    ]);
    exit;
}

/* =========================
   UPDATE (USER SAFE)
========================= */
$stmt = $conn->prepare("
    UPDATE expenses
    SET description = ?, amount = ?
    WHERE id = ?
      AND user_id = ?
    LIMIT 1
");

$stmt->bind_param(
    "sdii",
    $description,
    $amount,
    $id,
    $user_id
);

if ($stmt->execute() && $stmt->affected_rows >= 0) {
    echo json_encode([
        'success' => true,
        'message' => 'Expense updated successfully'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Update failed'
    ]);
}

$stmt->close();
