<?php
session_start();



header('Content-Type: application/json');

require "../config/db.php";

/* =========================
   AUTH
========================= */
if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Not logged in'
    ]);
    exit;
}

$user_id = (int) $_SESSION['user_id'];
$id      = isset($_POST['id']) ? (int) $_POST['id'] : 0;

if ($id <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid ID received'
    ]);
    exit;
}

/* =========================
   DELETE
========================= */
$sql = "DELETE FROM expenses WHERE id = ? AND user_id = ?";

$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        'success' => false,
        'message' => 'Prepare failed: ' . $conn->error
    ]);
    exit;
}

$stmt->bind_param("ii", $id, $user_id);

if (!$stmt->execute()) {
    echo json_encode([
        'success' => false,
        'message' => 'Execute failed: ' . $stmt->error
    ]);
    exit;
}

if ($stmt->affected_rows === 0) {
    echo json_encode([
        'success' => false,
        'message' => 'No record deleted (wrong ID or not your expense)'
    ]);
    exit;
}

$stmt->close();
$conn->close();

echo json_encode([
    'success' => true,
    'message' => 'Expense deleted successfully'
]);
