<?php
session_start();
header('Content-Type: application/json');
error_reporting(0);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']);
    exit;
}

require_once '../config/db.php';

$user_id      = $_SESSION['user_id'];
$amount       = $_POST['amount'] ?? null;
$savings_type = $_POST['savings_type'] ?? null;
$note         = $_POST['note'] ?? '';
$savings_date = $_POST['savings_date'] ?? null;

if (!$amount || $amount <= 0) {
    echo json_encode(['status'=>'error','message'=>'Invalid amount']);
    exit;
}

if (!$savings_type) {
    echo json_encode(['status'=>'error','message'=>'Savings type required']);
    exit;
}

if (!$savings_date) {
    echo json_encode(['status'=>'error','message'=>'Savings date missing']);
    exit;
}

// Optional: You can insert into expenses as "Savings" category (e.g., category_id = 12)
$category_id = 12; // Savings category

// Start transaction to ensure both inserts succeed together
$conn->begin_transaction();

try {
    // 1️⃣ Insert into expenses
    $expense_stmt = $conn->prepare("
        INSERT INTO expenses (user_id, category_id, amount, description, expense_date, created_at)
        VALUES (?, ?, ?, ?, ?, NOW())
    ");
    $description = "Savings - $savings_type" . ($note ? ": $note" : '');
    $expense_stmt->bind_param("iidss", $user_id, $category_id, $amount, $description, $savings_date);
    $expense_stmt->execute();

    // Get the inserted expense ID
    $expense_id = $conn->insert_id;

    // 2️⃣ Insert into savings
    $savings_stmt = $conn->prepare("
        INSERT INTO savings (expenses_id, user_id, amount, savings_type, note, savings_date, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())
    ");
    $savings_stmt->bind_param("iiisss", $expense_id, $user_id, $amount, $savings_type, $note, $savings_date);
    $savings_stmt->execute();

    // Commit transaction
    $conn->commit();

    $expense_stmt->close();
    $savings_stmt->close();
    $conn->close();

    echo json_encode(['status'=>'success','message'=>'Savings added successfully']);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['status'=>'error','message'=>'Failed to save savings','error'=>$e->getMessage()]);
}
