<?php
session_start();
header('Content-Type: application/json');
error_reporting(0);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']);
    exit;
}

require_once '../config/db.php';

$user_id = $_SESSION['user_id'];

// Collect POST data
$category_id = $_POST['category_id'] ?? 0;
$loan_source = $_POST['loan_source'] ?? '';
$amount      = (float)($_POST['amount'] ?? 0);
$loan_date   = $_POST['loan_date'] ?? '';
$description = $_POST['description'] ?? '';

// Validation
if (!$category_id || !$loan_source || $amount <= 0 || !$loan_date) {
    echo json_encode(['status'=>'error','message'=>'Please fill in all required fields']);
    exit;
}

$conn->begin_transaction();

try {

    /* =========================
       INSERT INTO LOANS
    ========================= */
    $loanStmt = $conn->prepare("
        INSERT INTO loans
        (user_id, category_id, loan_source, amount, loan_date, description, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())
    ");

    $loanStmt->bind_param(
        "iisdss",
        $user_id,
        $category_id,
        $loan_source,
        $amount,
        $loan_date,
        $description
    );

    if (!$loanStmt->execute()) {
        throw new Exception('Failed to save loan');
    }

    /* =========================
       INSERT INTO SALARIES (INCOME)
    ========================= */
    $income_type = 'loan';
    $note = 'Loan received from ' . ucfirst($loan_source);

    $salaryStmt = $conn->prepare("
        INSERT INTO salaries
        (user_id, income_type, amount, note, income_date, created_at)
        VALUES (?, ?, ?, ?, ?, NOW())
    ");

    $salaryStmt->bind_param(
        "isdss",
        $user_id,
        $income_type,
        $amount,
        $note,
        $loan_date
    );

    if (!$salaryStmt->execute()) {
        throw new Exception('Failed to record loan as income');
    }

    $conn->commit();

    echo json_encode(['status'=>'success']);

} catch (Exception $e) {

    $conn->rollback();
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
}

$loanStmt?->close();
$salaryStmt?->close();
$conn->close();
