<?php
session_start();
header('Content-Type: application/json');
error_reporting(0);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

require_once '../config/db.php';

$user_id = $_SESSION['user_id'];

/* INPUTS */
$income_type = $_POST['income_type'] ?? '';
$amount      = $_POST['amount'] ?? '';
$note        = $_POST['note'] ?? null;
$income_date = $_POST['income_date'] ?? date('Y-m-d');

/* VALIDATION */
if (!in_array($income_type, ['salary', 'side_hustle', 'others'])) {
    echo json_encode(['status'=>'error','message'=>'Invalid income type']);
    exit;
}

if (!is_numeric($amount) || $amount <= 0) {
    echo json_encode(['status'=>'error','message'=>'Invalid amount']);
    exit;
}

/* INSERT */
$stmt = $conn->prepare("
    INSERT INTO salaries
    (user_id, income_type, amount, note, income_date, created_at)
    VALUES (?, ?, ?, ?, ?, NOW())
");

$stmt->bind_param(
    "isdss",
    $user_id,
    $income_type,
    $amount,
    $note,
    $income_date
);

if ($stmt->execute()) {
    echo json_encode([
        'status'  => 'success',
        'message' => 'Income added successfully'
    ]);
} else {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Failed to save income'
    ]);
}

$stmt->close();
$conn->close();
