<?php
session_start();
header('Content-Type: application/json');
error_reporting(0);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status'=>'error','message'=>'Unauthorized']);
    exit;
}

require_once '../config/db.php';

$user_id = $_SESSION['user_id'];

$amounts      = $_POST['amount'] ?? [];
$categories   = $_POST['category_id'] ?? [];
$descriptions = $_POST['description'] ?? [];
$expense_date = $_POST['expense_date'] ?? null;

if (!$expense_date) {
    echo json_encode(['status'=>'error','message'=>'Expense date missing']);
    exit;
}

$total = count($amounts);

if ($total === 0) {
    echo json_encode(['status'=>'error','message'=>'No expenses provided']);
    exit;
}

// Prepare statements
$expense_stmt = $conn->prepare("
    INSERT INTO expenses
    (user_id, category_id, amount, description, expense_date, created_at)
    VALUES (?, ?, ?, ?, ?, NOW())
");

$savings_stmt = $conn->prepare("
    INSERT INTO savings
    (expenses_id, user_id, amount, savings_type, note, savings_date, created_at)
    VALUES (?, ?, ?, ?, ?, ?, NOW())
");

for ($i = 0; $i < $total; $i++) {
    if (empty($amounts[$i]) || $amounts[$i] <= 0) continue;
    if (empty($categories[$i])) continue;

    // Insert into expenses
    $expense_stmt->bind_param(
        "iidss",
        $user_id,
        $categories[$i],
        $amounts[$i],
        $descriptions[$i],
        $expense_date
    );
    $expense_stmt->execute();

    // Get the inserted expenses ID
    $expense_id = $conn->insert_id;

    // If category is 12 (Savings), insert into savings
    if ($categories[$i] == 12) {
        $savings_type = 'monthly'; // or get from input
        $note         = $descriptions[$i];
        $savings_stmt->bind_param(
            "iiisss",
            $expense_id, // <-- use the expenses table ID
            $user_id,
            $amounts[$i],
            $savings_type,
            $note,
            $expense_date
        );
        $savings_stmt->execute();
    }
}

$expense_stmt->close();
$savings_stmt->close();
$conn->close();

echo json_encode(['status'=>'success']);
