<?php
require "config/db.php";

/* GET ACTIVE PLANS */
$sql = "
SELECT *
FROM planned_expenses
WHERE planned_date = CURDATE()
";

$res = $conn->query($sql);

while ($row = $res->fetch_assoc()) {

    switch ($row['plan_type']) {
        case 'daily':
            $nextDate = date('Y-m-d', strtotime('+1 day'));
            break;
        case 'weekly':
            $nextDate = date('Y-m-d', strtotime('+7 days'));
            break;
        case 'monthly':
            $nextDate = date('Y-m-d', strtotime('+1 month'));
            break;
        default:
            continue 2;
    }

    $month = date('n', strtotime($nextDate));
    $year  = date('Y', strtotime($nextDate));

    $stmt = $conn->prepare("
        INSERT INTO planned_expenses
        (user_id, category_id, planned_amount, plan_type, note, planned_date, month, year, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())
    ");

    $stmt->bind_param(
        "iidsssii",
        $row['user_id'],
        $row['category_id'],
        $row['planned_amount'],
        $row['plan_type'],
        $row['note'],
        $nextDate,
        $month,
        $year
    );

    $stmt->execute();
}

echo "Plans generated successfully";
