<?php
header('Content-Type: application/json');
include "../config/db.php";

/* ================= VALIDATE REQUEST ================= */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request"
    ]);
    exit;
}

/* ================= GET FORM DATA ================= */
$name       = trim($_POST['name'] ?? '');
$contact    = trim($_POST['phone'] ?? '');
$password   = $_POST['password'] ?? '';
$occupation = trim($_POST['occupation'] ?? '');

$email   = null;
$country = null;

/* ================= BASIC VALIDATION ================= */
if ($name === '' || $contact === '' || $password === '') {
    echo json_encode([
        "status" => "error",
        "message" => "All required fields must be filled"
    ]);
    exit;
}

$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

/* ================= CHECK MOBILE EXISTS ================= */
$check = $conn->prepare("SELECT id FROM users WHERE Contact = ?");
$check->bind_param("s", $contact);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Mobile number already registered"
    ]);
    $check->close();
    $conn->close();
    exit;
}
$check->close();

/* ================= INSERT USER ================= */
$stmt = $conn->prepare("
    INSERT INTO users
    (name, Contact, email, password, created_at, occupation, country)
    VALUES (?, ?, ?, ?, NOW(), ?, ?)
");

$stmt->bind_param(
    "ssssss",
    $name,
    $contact,
    $email,
    $hashedPassword,
    $occupation,
    $country
);

if ($stmt->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "Account created successfully"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Registration failed"
    ]);
}

/* ================= CLOSE CONNECTION ================= */
$stmt->close();
$conn->close();
