<?php
session_start();
header('Content-Type: application/json');

include "../config/db.php";

/* Validate input */
if (!isset($_POST['phone'], $_POST['password'])) {
    echo json_encode([
        "status" => "error",
        "message" => "Missing login data"
    ]);
    exit;
}

$contact  = trim($_POST['phone']);
$password = $_POST['password'];

/* Query */
$stmt = $conn->prepare("
    SELECT id, password 
    FROM users 
    WHERE Contact = ?
");
$stmt->bind_param("s", $contact);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {

    $user = $result->fetch_assoc();

    if (password_verify($password, $user['password'])) {

        $_SESSION['user_id'] = $user['id'];

        echo json_encode([
            "status"   => "success",
            "message"  => "Login successful",
            "redirect" => "dashboard"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid password"
        ]);
    }

} else {
    echo json_encode([
        "status" => "error",
        "message" => "Mobile number not found"
    ]);
}

/* Close */
$stmt->close();
$conn->close();
