<?php
session_start();
if (!isset($_SESSION['user_id'])) exit;

require "../config/db.php";

$user_id  = $_SESSION['user_id'];
$category = $_POST['category'] ?? '';

$sql = "
SELECT e.expense_date, e.amount, e.note
FROM expenses e
JOIN categories c ON e.category_id = c.id
WHERE e.user_id = ?
  AND c.name = ?
  AND MONTH(e.expense_date) = MONTH(CURDATE())
  AND YEAR(e.expense_date)  = YEAR(CURDATE())
ORDER BY e.expense_date DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $user_id, $category);
$stmt->execute();
$res = $stmt->get_result();
?>

<table class="table table-sm">
<thead>
<tr>
  <th>Date</th>
  <th class="text-end">Amount</th>
  <th>Note</th>
</tr>
</thead>
<tbody>
<?php while ($r = $res->fetch_assoc()): ?>
<tr>
  <td><?= date('d M', strtotime($r['expense_date'])) ?></td>
  <td class="text-end">₵<?= number_format($r['amount'],2) ?></td>
  <td><?= htmlspecialchars($r['note']) ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
