<?php
/**
 * OTP Verification (Arkesel)
 * File: OTP/verify_registration_otp.php
 */

header('Content-Type: application/json');
require_once '../config/arkesel.php';

/* ================= VALIDATION ================= */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method'
    ]);
    exit;
}

if (empty($_POST['number']) || empty($_POST['code'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing OTP data'
    ]);
    exit;
}

$number = trim($_POST['number']);
$code   = trim($_POST['code']);

/* ================= ARKESEL REQUEST ================= */
$payload = http_build_query([
    'number' => $number,
    'code'   => $code
]);

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://sms.arkesel.com/api/otp/verify',
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'api-key: ' . ARKESEL_API_KEY
    ],
    CURLOPT_TIMEOUT => 15
]);

$response = curl_exec($curl);

/* ================= CURL ERROR ================= */
if ($response === false) {
    curl_close($curl);
    echo json_encode([
        'status' => 'error',
        'message' => 'OTP service unavailable'
    ]);
    exit;
}

curl_close($curl);

/* ================= RESPONSE PARSE ================= */
$data = json_decode($response, true);

if (!is_array($data)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid OTP response'
    ]);
    exit;
}

/*
 Arkesel OTP Verify Codes
 1100 = OTP verified
*/

if (isset($data['code']) && (int)$data['code'] === 1100) {
    echo json_encode([
        'status' => 'success',
        'message' => 'OTP verified successfully'
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => $data['message'] ?? 'Invalid or expired OTP'
    ]);
}
